﻿using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace DragAndDrop
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private const string formatLista = "Format_Lista";
        private const string formatElement = "Format_Element";

        private void ListBox_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            ListBox lbSender = sender as ListBox;

            ListBoxItem element = lbSender.GetItemAt(e.GetPosition(lbSender));
            if (element == null) return;

            DataObject dane = new DataObject();
            //dane.SetData(formatLista, lbSender);
            //dane.SetData(formatElement, element);           
            dane.SetData(DataFormats.Text, element.Content as string);

            DragDrop.DoDragDrop(lbSender, dane, DragDropEffects.Move | DragDropEffects.Copy);
        }

        private void ListBox_DragEnter(object sender, DragEventArgs e)
        {
            if (e.KeyStates.HasFlag(DragDropKeyStates.ControlKey))
                e.Effects = DragDropEffects.Copy;
            else e.Effects = DragDropEffects.Move;
        }

        private void ListBox_Drop(object sender, DragEventArgs e)
        {
            ListBox lbSender = sender as ListBox;

            //ListBox lbŹródło = e.Data.GetData(formatLista) as ListBox;
            //ListBoxItem element = e.Data.GetData(formatElement) as ListBoxItem;
            ListBoxItem element = new ListBoxItem() { Content = e.Data.GetData(DataFormats.Text) };

            //if (e.KeyStates.HasFlag(DragDropKeyStates.ControlKey))
            //{
            //    element = new ListBoxItem() { Content = element.Content };
            //}
            //else lbŹródło.Items.Remove(element);
            lbSender.Items.Add(element);
        }
    }
}
