﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

public static class WinAPI
{
    public const uint WM_CLOSE = 0x0010; //16
    public const uint WM_KEYDOWN = 0x0100;
    public const uint WM_CHAR = 0x0102;

    //nie ma
    [DllImport("user32.dll")]
    public static extern int SendMessage(IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam);

    //nie ma
    [DllImport("user32.dll")]
    public static extern int PostMessage(IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam);

    //nie ma
    [DllImport("user32.dll")]
    public static extern bool MessageBeep(uint rodzajDźwięku);

    //MessageBox
    [DllImport("user32.dll", EntryPoint = "MessageBox", CharSet = CharSet.Unicode)]
    public static extern int _MessageBox(IntPtr hWnd, string text, string caption, uint type);

    //System.Diagnostics.Process.Start
    [DllImport("kernel32.dll")]
    public static extern uint WinExec(string polecenie, uint stanOkna);

    public enum StanOkna : uint { Ukryty = 0, Normalny = 1, Zminimalizowany = 2, Zmaksymalizowany = 3 };

    //System.Diagnostics.Process.Start
    [DllImport("kernel32.dll")]
    public static extern uint WinExec(string polecenie, StanOkna stanOkna);

    //NET: DriveInfo
    [DllImport("kernel32.dll")]
    public static extern bool GetDiskFreeSpaceEx(
        string katalog,
        ref long wolneMiejsceDlaUżytkownika,
        ref long rozmiarDysku,
        ref long wolneMiejsceNaDysku);

    public static int PobierzProcentZajętościDysku(string katalogGłównyDysku)
    {
        long wolneMiejsceDlaUżytkownika = 0, rozmiarDysku = 0, wolneMiejsceNaDysku = 0;
        bool wynik = GetDiskFreeSpaceEx(katalogGłównyDysku, ref wolneMiejsceDlaUżytkownika, ref rozmiarDysku, ref wolneMiejsceNaDysku);
        if (wynik) return (int)Math.Round(100.0 * (rozmiarDysku - wolneMiejsceNaDysku) / rozmiarDysku);
        else return -1;
    }

    public const int MAX_PATH = 260;

    [DllImport("kernel32.dll")]
    public static extern uint GetWindowsDirectory(StringBuilder bufor, uint rozmiarBufora);

    [DllImport("kernel32.dll")]
    public static extern uint GetSystemDirectory(StringBuilder bufor, uint rozmiarBufora);

    [DllImport("gdi32.dll")]
    public static extern int BitBlt(IntPtr hDC, int x, int y, int width, int height, IntPtr hSrcDC, int xSrc, int ySrc, int operacja);

    [DllImport("user32.dll")]
    public static extern bool GetPhysicalCursorPos(ref Point point);

    [DllImport("user32.dll")]
    public static extern bool SetProcessDPIAware();
}