﻿using System.ComponentModel;
using System.Windows.Input;

namespace RównaniaKwadratowe2.ModelWidoku
{
    public class ModelWidokuRównańKwadratowych : INotifyPropertyChanged
    {
        //private WspółczynnikiRównaniaKwadratowego współczynniki = new WspółczynnikiRównaniaKwadratowego();
        private RozwiązywaczRównańKwadratowych model = new RozwiązywaczRównańKwadratowych();

        public double X1
        {
            get
            {
                return model.X1;
            }
        }

        public double X2
        {
            get
            {
                return model.X2;
            }
        }

        /*
        public double A
        {
            set
            {                
                współczynniki.A = value;
            }
        }

        public double B
        {
            set
            {
                współczynniki.B = value;
            }
        }

        public double C
        {
            set
            {
                współczynniki.C = value;
            }
        }
        */

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if(PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X1)));
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X2)));
            }
        }

        /*
        public ModelWidokuRównańKwadratowych()
        {
            rozwiąż = new RozwiążCommand(model);
            rozwiąż.Executed += (object sender, System.EventArgs e) => { onPropertyChanged(); };
        }
        */

        private ICommand rozwiąż = null;

        public ICommand Rozwiąż
        {
            get
            {
                if(rozwiąż == null)
                {
                    rozwiąż = new RelayCommand(
                        (object parameter) => 
                        {
                            WspółczynnikiRównaniaKwadratowego współczynniki = (WspółczynnikiRównaniaKwadratowego)parameter;
                            model.Rozwiąż(współczynniki);
                            onPropertyChanged();
                        },
                        (object parameter) => 
                        {
                            if (parameter == null) return false;
                            WspółczynnikiRównaniaKwadratowego współczynniki = (WspółczynnikiRównaniaKwadratowego)parameter;
                            return współczynniki.CzyIstniejąRozwiązania;
                        });
                }
                return rozwiąż;
            }
        }
    }
}
