﻿using System;
using System.Globalization;
using System.Windows.Data;

namespace RównaniaKwadratowe2
{
    public class DoubleToStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            double wartość = (double)value;
            return wartość.ToString(culture);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string łańcuch = (string)value;
            if (string.IsNullOrEmpty(łańcuch)) return 0;
            else return double.Parse(łańcuch, culture);
        }
    }
}
