﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DrugaAplikacjaMvvm1.ViewModel
{
    using Model;
    using System.ComponentModel;
    using System.Windows.Input;

    public class ViewModelDAM : INotifyPropertyChanged
    {
        private Model.ModelDanych model = new ModelDanych();

        public ViewModelDAM()
        {
            model.LoadSettings();
            onPropertyChanged();
        }

        public string Text
        {
            get
            {
                return model.Text;
            }
            set
            {
                model.Text = value;
                onPropertyChanged();                
            }
        }

        private void onPropertyChanged()
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(Text)));

        }

        public event PropertyChangedEventHandler PropertyChanged;
        
        private ICommand ustawUMK;
        public ICommand UstawUMK
        {
            get
            {
                if (ustawUMK == null)
                    ustawUMK = new RelayCommand(
                        (object p) =>
                        {
                            model.UstawUMK();
                            onPropertyChanged();
                        },
                        (object p) =>
                        {
                            return !model.CzyUMK;
                        });
                return ustawUMK;
            }
        }

        public ICommand Zapisz
        {
            get
            {
                return new RelayCommand(
                    (object p) => { model.SaveSettings(); });
            }
        }
    }
}
