﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Effects;

namespace Zegar
{
    class Efekt : ShaderEffect
    {
        private static Uri getEffectResourceUri(string effectFileName)
        {
            string assemblyShortName = typeof(Efekt).Assembly.ToString().Split(',')[0];
            string uriString = "pack://application:,,,/" + assemblyShortName + ";component/" + effectFileName;
            return new Uri(uriString);
        }

        public static DependencyProperty KolorProperty =
            DependencyProperty.Register(nameof(Kolor), typeof(Color), typeof(Efekt),
                new PropertyMetadata(Colors.White, PixelShaderConstantCallback(0)));

        public Color Kolor
        {
            get { return (Color)GetValue(KolorProperty); }
            set { SetValue(KolorProperty, value); }
        }

        public static DependencyProperty InputProperty =
            RegisterPixelShaderSamplerProperty(nameof(Input), typeof(Efekt), 0);

        public Brush Input
        {
            get { return (Brush)GetValue(InputProperty); }
        }

        private static readonly DependencyProperty CzasProperty =
            DependencyProperty.Register(nameof(Czas), typeof(double), typeof(Efekt),
                new PropertyMetadata(0.0, PixelShaderConstantCallback(1)));

        public double Czas
        {
            get { return (double)GetValue(CzasProperty); }
            set
            {
                SetValue(CzasProperty, value);
                UpdateShaderValue(CzasProperty);
            }
        }

        public Efekt()
        {
            this.PixelShader = new PixelShader() { UriSource = getEffectResourceUri("Efekt.ps") }; ;

            UpdateShaderValue(KolorProperty);
            UpdateShaderValue(InputProperty);
        }
    }
}
