﻿using System;
using System.Windows;
using System.Windows.Input;

using Microsoft.Xaml.Behaviors;

namespace Zegar
{
    class EscKeyClosingWindowBehavior : Behavior<Window>
    {
        protected override void OnAttached()
        {
            Window window = this.AssociatedObject;
            window.PreviewKeyDown += window_PreviewKeyDown;
        }

        private void window_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            if(e.Key == Key.Escape)
            {
                (sender as Window).Close();
            }
        }
    }

    class DraggingWindowBehavior : Behavior<Window>
    {
        protected override void OnAttached()
        {
            Window window = this.AssociatedObject;
            window.MouseDown += window_MouseDown;
            window.MouseMove += window_MouseMove;
            window.MouseUp += window_MouseUp;
            window.Deactivated += window_Deactivated;            
        }

        private bool isDragging = false;
        private Point startCursorPosition;

        private void window_MouseDown(object sender, MouseButtonEventArgs e)
        {
            if(!isDragging && e.LeftButton == MouseButtonState.Pressed)
            {
                isDragging = true;
                startCursorPosition = e.GetPosition(sender as Window);
            }
        }

        private void window_MouseMove(object sender, MouseEventArgs e)
        {
            if(isDragging)
            {
                Window window = sender as Window;
                Vector translation = 
                    e.GetPosition(window) - startCursorPosition;
                window.Left += translation.X;
                window.Top += translation.Y;
            }
        }

        private void window_MouseUp(object sender, MouseButtonEventArgs e)
        {
            if (isDragging) isDragging = false;
        }

        private void window_Deactivated(object sender, EventArgs e)
        {
            window_MouseUp(sender, null);
        }
    }
}
