﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace KolekcjeWPF.Model
{
    public class Zadania : IEnumerable<Zadanie>
    {
        private List<Zadanie> listaZadań = new List<Zadanie>();

        //CRUD
        public void Dodaj(Zadanie zadanie)
        {
            listaZadań.Add(zadanie);
        }

        public bool Usuń(Zadanie zadanie)
        {
            return listaZadań.Remove(zadanie);
        }

        public Zadanie this[int indeks]
        {
            get
            {
                return listaZadań[indeks];
            }
        }

        public int Liczba
        {
            get
            {
                return listaZadań.Count;
            }
        }

        public IEnumerator<Zadanie> GetEnumerator()
        {
            return listaZadań.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }
}
