﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace KolekcjeWPF.ModelWidoku
{
    using System.Collections.ObjectModel;
    using System.Collections.Specialized;
    using static Model.PlikXml;

    public class Zadania
    {
        private Model.Zadania model = null;

        public ObservableCollection<Zadanie> ListaZadań { get; } = new ObservableCollection<Zadanie>();

        private void kopiujZadaniaZModelu()
        {
            ListaZadań.CollectionChanged -= synchronizacjaModelu;
            foreach (Model.Zadanie zadanie in model) ListaZadań.Add(new Zadanie(zadanie));
            ListaZadań.CollectionChanged += synchronizacjaModelu;
        }

        public Zadania()
        {
            string ścieżkaPliku = "zadania.xml";
            if (System.IO.File.Exists(ścieżkaPliku)) model = Czytaj("zadania.xml");
            else model = new Model.Zadania();

            model.Dodaj(
                new Model.Zadanie(
                    "Zadanie 1", 
                    DateTime.Now.AddDays(1), 
                    DateTime.Now, 
                    Model.PriorytetZadania.Ważne));
            model.Dodaj(
                new Model.Zadanie(
                    "Zadanie 2",
                    DateTime.Now.AddDays(2),
                    DateTime.Now,
                    Model.PriorytetZadania.MniejWażne));

            kopiujZadaniaZModelu();
        }

        private void synchronizacjaModelu(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch (e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    Zadanie noweZadanie = (Zadanie)e.NewItems[0];
                    model.Dodaj(noweZadanie.GetModel());
                    break;
                case NotifyCollectionChangedAction.Remove:
                    Zadanie usuwaneZadanie = (Zadanie)e.OldItems[0];
                    model.Usuń(usuwaneZadanie.GetModel());
                    break;
            }
        }
    }
}
