﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace KolekcjeWPF.Model
{
    public enum PriorytetZadania : byte { MniejWażne, Standardowe, Ważne, Krytyczne };

    public class Zadanie
    {
        public string Opis { get; private set; }
        public DateTime PlanowanaDataRealizacji { get; private set; }
        public DateTime DataUtworzenia { get; private set; }
        public PriorytetZadania Priorytet { get; private set; }
        public bool CzyZrealizowane { get; set; }

        public Zadanie(
            string opis, 
            DateTime planowanaDataRealizacji, DateTime dataUtworzenia,
            PriorytetZadania priorytet = PriorytetZadania.Standardowe, bool czyZrealizwane = false)
        {
            this.Opis = opis;
            this.PlanowanaDataRealizacji = planowanaDataRealizacji;
            this.DataUtworzenia = dataUtworzenia;
            this.Priorytet = priorytet;
            this.CzyZrealizowane = czyZrealizwane;
        }

        public override string ToString()
        {
            return 
                Opis + ", " + PlanowanaDataRealizacji.ToString() + ", " + 
                Priorytet.ToString() + ", " + CzyZrealizowane.ToString();
        }
    }
}
