﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace KolekcjeWPF.ModelWidoku
{
    using System.Collections.ObjectModel;
    using System.Collections.Specialized;
    using System.Windows.Input;
    using static Model.PlikXml;

    public class Zadania
    {
        private Model.Zadania model = null;

        public ObservableCollection<Zadanie> ListaZadań { get; } = new ObservableCollection<Zadanie>();

        private void kopiujZadaniaZModelu()
        {
            ListaZadań.CollectionChanged -= synchronizacjaModelu;
            foreach (Model.Zadanie zadanie in model) ListaZadań.Add(new Zadanie(zadanie));
            ListaZadań.CollectionChanged += synchronizacjaModelu;
        }

        private const string ścieżkaPliku = "zadania.xml";

        public Zadania()
        {
            if (System.IO.File.Exists(ścieżkaPliku)) model = Czytaj(ścieżkaPliku);
            else model = new Model.Zadania();

            /*
            model.Dodaj(
                new Model.Zadanie(
                    "Zadanie 1", 
                    DateTime.Now.AddDays(1), 
                    DateTime.Now, 
                    Model.PriorytetZadania.Ważne));
            model.Dodaj(
                new Model.Zadanie(
                    "Zadanie 2",
                    DateTime.Now.AddDays(2),
                    DateTime.Now,
                    Model.PriorytetZadania.MniejWażne));
            */

            kopiujZadaniaZModelu();
        }

        private void synchronizacjaModelu(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch (e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    Zadanie noweZadanie = (Zadanie)e.NewItems[0];
                    model.Dodaj(noweZadanie.GetModel());
                    break;
                case NotifyCollectionChangedAction.Remove:
                    Zadanie usuwaneZadanie = (Zadanie)e.OldItems[0];
                    model.Usuń(usuwaneZadanie.GetModel());
                    break;
            }
        }

        private ICommand zapisz;

        public ICommand Zapisz
        {
            get
            {
                if (zapisz == null)
                    zapisz = new RelayCommand(
                        p =>
                        {
                            model.Zapisz(ścieżkaPliku);
                        });
                return zapisz;
            }
        }

        private ICommand usuńZadanie;

        public ICommand UsuńZadanie
        {
            get
            {
                if (usuńZadanie == null)
                    usuńZadanie = new RelayCommand(
                        p =>
                        {
                            int indeksZadania = (int)p;
                            Zadanie zadanie = ListaZadań[indeksZadania];
                            ListaZadań.Remove(zadanie);
                        },
                        p =>
                        {
                            if (p == null) return false;
                            int indeksZadania = (int)p;
                            return indeksZadania >= 0 && indeksZadania < ListaZadań.Count;
                        });
                return usuńZadanie;
            }
        }

        private ICommand dodajZadanie;

        public ICommand DodajZadanie
        {
            get
            {
                if (dodajZadanie == null)
                    dodajZadanie = new RelayCommand(
                        p =>
                        {
                            Zadanie zadanie = p as Zadanie;
                            ListaZadań.Add(zadanie);
                        },
                        p =>
                        {
                            Zadanie zadanie = p as Zadanie;
                            return zadanie != null;
                        }
                        );
                return dodajZadanie;
            }
        }
    }
}
